<?php

// Utility code used to build a vbadvanced module
// At minimum, this needs a wrap-around as follows:
//
// 		$vba_module = create_vba_module("Module Title", "Module Identifier", "phpFile");
// 		save_vba_module($vba_module, "Module filename");
//
//
// Between the calls to create and to save, there can be one or more calls to add_vba_setting() to define
// parameters which can be set by the admin:
//
// 		add_vba_setting($vba_module, "varname", "grouptitle", "title", "description" [, "optioncode"] [, "value"] [, "defaultvalue"]);
//

/**
* Create vba module definition
*
* @param	str		Module title
* @param	str		vba module identifier
* @param	str		.php file containing module's code
* @param	str		.xml file containing module's templates
* @param	str		If set, a list of templates other than those in .xml file which should be pre-loaded when using module
* @param	str		="1" (default) - module should use the adv_portal_module_wrapper template, ="0", not wrapped
* @param	int		if set, use as colspan for module's title row
* @return	array	Module object
*/

function create_vba_module($title, $identifier, $file, $templates="", $othertemplates="", $useshell="1", $colspan="0") {

	$vba_module = array();

	if ($templates) {
		$templatelist = array();
		$fp = @fopen($templates, "r");
		if (!$fp) {
			echo "Unable to open template file '".$templates."'";
			die();
		}
		$xml = fread($fp, 10240000);
		if (!$xml) {
			echo "Unable to read template file '".$templates."'";
			die();
		}
		fclose($fp);
		$xmlobj = new XMLparser($xml);
		if ($xmlobj->error_no == 1 or $xmlobj->error_no == 2) {
			echo "Unable to create xml parser for '".$templates."'";
			die();
		}
		if (!$arr =& $xmlobj->parse()) {
			echo "Unable to parse template file '".$templates."'";
			die();
		}
		if (isset($arr["template"][0])) {
			foreach ($arr["template"] as $thisarr) {
				$vba_module["templates"][$thisarr["name"]] = $thisarr["value"];
				$templatelist[] = $thisarr["name"];
			}
		}
		else {
			$vba_module["templates"][$arr["template"]["name"]] = $arr["template"]["value"];
			$templatelist[] = $arr["template"]["name"];
		}
//		$vba_module["templates"] = serialize($vba_module["templates"]);
		$templatelist = implode(',', $templatelist);
	}
	else {
		$templatelist = "";
	}
	if ($othertemplates) {
		$templatelist .= ",".$othertemplates;
	}

	$vba_module["module"] = array(
		"title" => $title,
		"identifier" => $identifier,
		"inctype" => "php_file",
		"parent" => "",
		"templatelist" => $templatelist,
		"colspan" => "$colspan",
		"formcode" => "",
		"cleanoutput" => "0",
		"options" => "",
		"useshell" => "$useshell",
		"link" => "",
	);

	$fp = @fopen($file, "r");
	if (!$fp) {
		echo "Unable to open template file '".$templates."'";
		die();
	}
	$vba_module["file"] = fread($fp, 1024000);
	fclose($fp);

	$vba_module["module"]["filename"] = $identifier.".php";
//	$vba_module["module"] = serialize($vba_module["module"]);

	return $vba_module;
}

/**
* Updates vba module definition to include a parameter which can be set by admin
*
* @param	array	Module object created by create_vba_module()
* @param	str		parameter id
* @param	str		parameter group id (shold be same for all settings of module
* @param	str		textual name for parameter
* @param	str		textual description for parameter
* @param	str		parameter type: 
* 					'' (default) textbox, 'textarea', 'yesno' radio button, 'forumselect' menu, 'calendarselect' menu, 'threadselect' menu
* @param	str		current value of the setting (normally leave blank)
* @param	str		default value of the setting (default - blank)
* @return	array	Module object
*/

function add_vba_setting(&$vba_module, $varname, $grouptitle, $title, $description, $optioncode="", $value="", $defaultvalue="") {
	global $option_codes;

	if (!isset($vba_module["settings"])) {
		$vba_module["settings"] = array();
		$displayorder = 1;
	}
	else {
		foreach ($vba_module["settings"] as $setting) {
			$displayorder = $setting["displayorder"] + 1;
		}
	}

	$vba_module["settings"][$varname] = array(
		"varname" => "$varname",
		"grouptitle" => "$grouptitle",
		"value" => "$value",
		"defaultvalue" => "$defaultvalue",
		"optioncode" => "$optioncode",
		"displayorder" => "$displayorder",
		"serialize" => ($optioncode=="forumselect" || $optioncode=="threadselect" ? "1" : "0" ),
		"title" => "$title",
		"description" => "$description",
	);

}

/**
* Save vba module to file
*
* @param	array	Module object created by create_vba_module()
* @param	str		vba module file
*/

function save_vba_module($vba_module, $file) {
	$vba_module = serialize($vba_module);
	$fp = @fopen($file, "w");
	if (!$fp) {
		echo "Unable to open module file '".$file."'";
		die();
	}
	fwrite($fp, $vba_module);
	fclose($fp);
}

?>



